/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.delta;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.openzen.zengarden.delta.ArrayDeltaBuilder;
import org.openzen.zengarden.delta.DataDelta;
import org.openzen.zengarden.io.DataOutput;

public class ByteBufferDelta
implements DataDelta<ByteBuffer> {
    private final DataDelta<byte[]> byteUpdates;

    public static ByteBufferDelta create(ByteBuffer data) {
        byte[] bytes = new byte[data.limit()];
        data.get(bytes);
        return new ByteBufferDelta(ArrayDeltaBuilder.BYTE.getBuilder().insert(bytes).end());
    }

    public ByteBufferDelta(DataDelta<byte[]> byteUpdates) {
        this.byteUpdates = byteUpdates;
    }

    @Override
    public ByteBuffer update(ByteBuffer value) {
        value.rewind();
        byte[] data = new byte[value.limit()];
        value.get(data);
        byte[] modified = this.byteUpdates.update(data);
        return ByteBuffer.wrap(modified);
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        this.byteUpdates.serialize(output);
    }
}

