/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.IOException;
import org.openzen.zengarden.io.BitInput;

public class BitInputArray
implements BitInput {
    private final byte[] data;
    private int offset = 0;
    private long buffer = 0L;
    private int bufferBits = 0;

    public BitInputArray(byte[] data) {
        this.data = data;
    }

    @Override
    public int read(int bits) throws IOException {
        int result = this.peek(bits);
        this.bufferBits -= bits;
        this.buffer >>>= bits;
        return result;
    }

    @Override
    public int peek(int bits) {
        while (this.bufferBits < bits) {
            if (this.offset < this.data.length) {
                this.buffer |= (long)this.data[this.offset++] << this.bufferBits;
            }
            this.bufferBits += 8;
        }
        return (int)(this.buffer & (long)((1 << bits) - 1));
    }

    @Override
    public void close() {
    }
}

