/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.collections;

import java.util.Iterator;
import org.openzen.zengarden.collections.ZList;

public class ZSingletonList<T>
implements ZList<T> {
    private final Class<T> cls;
    private final T item;

    public ZSingletonList(Class<T> cls, T item) {
        this.cls = cls;
        this.item = item;
    }

    @Override
    public boolean add(int index, T value) {
        throw new UnsupportedOperationException("Cannot modify a singleton");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot modify a singleton");
    }

    @Override
    public T get(int index) {
        return this.item;
    }

    @Override
    public T set(int index, T value) {
        throw new UnsupportedOperationException("Cannot modify a singleton");
    }

    @Override
    public int indexOf(T value) {
        return value == this.item ? 0 : -1;
    }

    @Override
    public int lastIndexOf(T value) {
        return value == this.item ? 0 : -1;
    }

    @Override
    public Class<T> getElementClass() {
        return this.cls;
    }

    @Override
    public boolean add(T value) {
        throw new UnsupportedOperationException("Cannot modify a singleton");
    }

    @Override
    public boolean remove(T value) {
        throw new UnsupportedOperationException("Cannot modify a singleton");
    }

    @Override
    public boolean contains(T value) {
        return value == this.item;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot modify a singleton");
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonIterator();
    }

    private class SingletonIterator
    implements Iterator<T> {
        private boolean done = false;

        private SingletonIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public T next() {
            this.done = true;
            return ZSingletonList.this.item;
        }
    }
}

