/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.delta;

import java.io.IOException;
import org.openzen.zengarden.arrays.ArrayFunctions;
import org.openzen.zengarden.delta.DataDelta;
import org.openzen.zengarden.io.BytesDataInput;
import org.openzen.zengarden.io.DataInput;
import org.openzen.zengarden.io.DataOutput;

public class ArrayDelta<A>
implements DataDelta<A> {
    private final ArrayFunctions<A> functions;
    private final byte[] data;

    public ArrayDelta(ArrayFunctions<A> functions, byte[] data) {
        this.functions = functions;
        this.data = data;
    }

    public ArrayDelta(ArrayFunctions<A> functions, DataInput input) throws IOException {
        this.functions = functions;
        this.data = input.readBytes();
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        output.writeBytes(this.data);
    }

    public int length() {
        return this.data.length;
    }

    @Override
    public A update(A original) {
        A output = this.functions.newArray(this.getOutputLength(this.functions.getLength(original)));
        BytesDataInput input = new BytesDataInput(this.data);
        int inputPointer = 0;
        int outputPointer = 0;
        while (true) {
            int cmd;
            if (((cmd = input.readVarUInt()) & 3) == 0) {
                A values = this.functions.readRaw(input, cmd >> 2);
                this.functions.copyArray(values, 0, output, outputPointer, this.functions.getLength(values));
                outputPointer += this.functions.getLength(values);
                continue;
            }
            if ((cmd & 3) == 1) {
                int length = cmd >> 2;
                if (length == 0) {
                    this.functions.copyArray(original, inputPointer, output, outputPointer, this.functions.getLength(original) - inputPointer);
                    break;
                }
                this.functions.copyArray(original, inputPointer, output, outputPointer, length);
                inputPointer += length;
                continue;
            }
            if ((cmd & 3) != 2) break;
            inputPointer += cmd >> 2;
        }
        return output;
    }

    private int getOutputLength(int inputLength) {
        int result = 0;
        int pointer = 0;
        BytesDataInput input = new BytesDataInput(this.data);
        while (true) {
            int length;
            int cmd;
            if (((cmd = input.readVarUInt()) & 3) == 0) {
                length = cmd >> 2;
                result += length;
                this.functions.readRaw(input, length);
                continue;
            }
            if ((cmd & 3) == 1) {
                length = cmd >> 2;
                if (length == 0) {
                    result += inputLength - pointer;
                    break;
                }
                pointer += length;
                continue;
            }
            if ((cmd & 3) != 2) break;
            pointer += cmd >> 2;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder;
        block4: {
            builder = new StringBuilder();
            BytesDataInput input = new BytesDataInput(this.data);
            while (true) {
                int cmd;
                if (((cmd = input.readVarUInt()) & 3) == 0) {
                    A strBytes = this.functions.readRaw(input, cmd >> 2);
                    builder.append(" Insert(").append(this.functions.getLength(strBytes)).append(" bytes)");
                    continue;
                }
                if ((cmd & 3) == 1) {
                    int length = cmd >> 2;
                    if (length == 0) {
                        builder.append(" CopyTilEnd");
                        break block4;
                    }
                    builder.append(" Copy(").append(length).append(")");
                    continue;
                }
                if ((cmd & 3) != 2) break;
                builder.append(" Skip(").append(cmd >> 2).append(")");
            }
            builder.append(" End");
        }
        return builder.toString().trim();
    }
}

