/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.util.Arrays;
import org.openzen.zengarden.io.BitOutput;

public class BitOutputArray
implements BitOutput {
    private byte[] data = new byte[16];
    private int dataLength = 0;
    private long buffer = 0L;
    private long bufferBits = 0L;

    @Override
    public void write(int data, int bits) {
        this.buffer |= (long)(data << (int)this.bufferBits);
        this.bufferBits += (long)bits;
        while (this.bufferBits >= 8L) {
            this.write((byte)this.buffer);
            this.buffer >>>= 8;
            this.bufferBits -= 8L;
        }
    }

    @Override
    public void flush() {
        if (this.bufferBits > 0L) {
            this.write((byte)this.buffer);
            this.bufferBits = 0L;
            this.buffer = 0L;
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    public int getLength() {
        return this.dataLength;
    }

    public byte[] getArray() {
        return Arrays.copyOf(this.data, this.dataLength);
    }

    public byte[] getRawArray() {
        return this.data;
    }

    private void write(byte data) {
        if (this.dataLength == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        this.data[this.dataLength++] = data;
    }
}

