/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.IOException;
import java.io.InputStream;
import org.openzen.zengarden.io.BytesDataOutput;
import org.openzen.zengarden.io.RuntimeIOException;
import org.openzen.zengarden.util.Charsets;

public class InputStreams {
    private InputStreams() {
    }

    public static byte[] readFully(InputStream input) {
        try {
            BytesDataOutput output = new BytesDataOutput();
            byte[] buffer = new byte[65536];
            int read = input.read(buffer);
            while (read >= 0) {
                output.writeRawBytes(buffer, 0, read);
                read = input.read(buffer);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String readUTF(InputStream input) {
        return new String(InputStreams.readFully(input), Charsets.UTF_8);
    }
}

