/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.lexer;

public class CharStream {
    private char[] data;
    private int index;

    public CharStream(String data) {
        this.data = data.toCharArray();
        this.index = 0;
    }

    public char peek() {
        if (this.index == this.data.length) {
            return '\u0000';
        }
        return this.data[this.index];
    }

    public boolean peek(char ch) {
        if (this.index == this.data.length) {
            return false;
        }
        return this.data[this.index] == ch;
    }

    public boolean optional(char ch) {
        if (this.index == this.data.length) {
            return false;
        }
        if (this.data[this.index] == ch) {
            ++this.index;
            return true;
        }
        return false;
    }

    public char optional(char from, char to) {
        if (this.index == this.data.length) {
            return '\u0000';
        }
        if (this.data[this.index] >= from && this.data[this.index] <= to) {
            return this.data[this.index++];
        }
        return '\u0000';
    }

    public void required(char ch) {
        if (this.index >= this.data.length) {
            throw new IllegalArgumentException("Expected " + ch + " but got EOF");
        }
        if (this.data[this.index] != ch) {
            throw new IllegalArgumentException("Expected " + ch + " but got " + this.data[this.index]);
        }
        ++this.index;
    }

    public char required(char from, char to) {
        if (this.data[this.index] < from || this.data[this.index] > to) {
            throw new IllegalArgumentException("Unexpected character: " + this.data[this.index]);
        }
        return this.data[this.index++];
    }

    public char next() {
        if (this.index >= this.data.length) {
            return '\u0000';
        }
        return this.data[this.index++];
    }

    public boolean hasMore() {
        return this.index < this.data.length;
    }
}

