/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import java.util.Iterator;
import org.openzen.zengarden.events.ListenerHandle;
import org.openzen.zengarden.watched.WatchedList;
import org.openzen.zengarden.watched.WatchedListListener;

public class LockedWatchedList<T>
implements WatchedList<T> {
    private final WatchedList<T> original;

    public LockedWatchedList(WatchedList<T> original) {
        this.original = original;
    }

    @Override
    public WatchedList<T> lock() {
        return this;
    }

    @Override
    public ListenerHandle<WatchedListListener<T>> addListener(WatchedListListener<T> listener) {
        return this.original.addListener(listener);
    }

    @Override
    public boolean add(int index, T value) {
        throw new UnsupportedOperationException("Cannot add to a locked list");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot remove from a locked list");
    }

    @Override
    public T get(int index) {
        return this.original.get(index);
    }

    @Override
    public T set(int index, T value) {
        throw new UnsupportedOperationException("Cannot modify a locked list");
    }

    @Override
    public int indexOf(T value) {
        return this.original.indexOf(value);
    }

    @Override
    public int lastIndexOf(T value) {
        return this.original.lastIndexOf(value);
    }

    @Override
    public Class<T> getElementClass() {
        return this.original.getElementClass();
    }

    @Override
    public boolean add(T value) {
        throw new UnsupportedOperationException("Cannot add to a locked list");
    }

    @Override
    public boolean remove(T value) {
        throw new UnsupportedOperationException("Cannot remove from a locked list");
    }

    @Override
    public boolean contains(T value) {
        return this.original.contains(value);
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear a locked list");
    }

    @Override
    public Iterator<T> iterator() {
        return new SafeIterator(this.original.iterator());
    }

    @Override
    public LockedWatchedList<T> watch() {
        return this;
    }

    private class SafeIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;

        public SafeIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }
    }
}

