/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.IOException;
import java.io.InputStream;
import org.openzen.zengarden.io.BitInput;
import org.openzen.zengarden.io.RuntimeIOException;

public class BitInputStream
implements BitInput {
    private final InputStream input;
    private long buffer = 0L;
    private int bufferBits = 0;
    private IOException error = null;

    public BitInputStream(InputStream input) {
        this.input = input;
    }

    @Override
    public int read(int bits) {
        int result = this.peek(bits);
        if (this.error != null) {
            IOException e = this.error;
            this.error = null;
            throw new RuntimeIOException(e);
        }
        this.bufferBits -= bits;
        this.buffer >>>= bits;
        return result;
    }

    @Override
    public int peek(int bits) {
        while (this.bufferBits < bits) {
            try {
                this.buffer |= (long)this.input.read() << this.bufferBits;
            }
            catch (IOException ex) {
                this.error = ex;
            }
            this.bufferBits += 8;
        }
        return (int)(this.buffer & (long)((1 << bits) - 1));
    }

    @Override
    public void close() {
        try {
            this.input.close();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }
}

