/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openzen.zengarden.io.BitOutput;
import org.openzen.zengarden.io.RuntimeIOException;

public class BitOutputStream
implements BitOutput {
    private final OutputStream output;
    private long buffer = 0L;
    private long bufferBits = 0L;

    public BitOutputStream(OutputStream output) {
        this.output = output;
    }

    @Override
    public void write(int data, int bits) {
        this.buffer |= (long)(data << (int)this.bufferBits);
        this.bufferBits += (long)bits;
        while (this.bufferBits >= 8L) {
            try {
                this.output.write((int)(this.buffer & 0xFFL));
                this.buffer >>>= 8;
                this.bufferBits -= 8L;
            }
            catch (IOException ex) {
                throw new RuntimeIOException(ex);
            }
        }
    }

    @Override
    public void flush() {
        try {
            if (this.bufferBits > 0L) {
                this.output.write((int)this.buffer);
                this.bufferBits = 0L;
                this.buffer = 0L;
            }
            this.output.flush();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.output.close();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }
}

