/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.io;

import org.openzen.zengarden.io.DataOutput;

public interface Serializer<T> {
    public static final Serializer<Integer> VARINT = (output, value) -> output.writeVarInt((int)value);
    public static final Serializer<Integer> VARUINT = (output, value) -> output.writeVarUInt((int)value);
    public static final Serializer<String> STRING = (output, value) -> output.writeString((String)value);
    public static final Serializer<boolean[]> BOOLARRAY = (output, value) -> {
        output.writeVarUInt(((boolean[])value).length);
        for (int i = 0; i < ((boolean[])value).length; i += 8) {
            int bvalue = 0;
            if (value[i + 0]) {
                ++bvalue;
            }
            if (value[i + 1]) {
                bvalue += 2;
            }
            if (value[i + 2]) {
                bvalue += 4;
            }
            if (value[i + 3]) {
                bvalue += 8;
            }
            if (value[i + 4]) {
                bvalue += 16;
            }
            if (value[i + 5]) {
                bvalue += 32;
            }
            if (value[i + 6]) {
                bvalue += 64;
            }
            if (value[i + 7]) {
                bvalue += 128;
            }
            output.writeUByte(bvalue);
        }
        if (((boolean[])value).length % 7 > 0) {
            int bvalue = 0;
            int offset = (((boolean[])value).length >> 8) * 8;
            for (int i = 0; i < ((boolean[])value).length % 7; ++i) {
                if (!value[offset + i]) continue;
                bvalue += 1 << i;
            }
            output.writeUByte(bvalue);
        }
    };

    public void serialize(DataOutput var1, T var2);
}

