/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import java.util.Iterator;
import org.openzen.zengarden.collections.ZList;
import org.openzen.zengarden.events.ListenerHandle;
import org.openzen.zengarden.events.ListenerList;
import org.openzen.zengarden.watched.LockedWatchedList;
import org.openzen.zengarden.watched.WatchedList;
import org.openzen.zengarden.watched.WatchedListListener;

public class BasicWatchedList<T>
implements WatchedList<T> {
    private final ZList<T> list;
    private final ListenerList<WatchedListListener<T>> listeners = new ListenerList();

    public BasicWatchedList(ZList<T> list) {
        this.list = list;
    }

    @Override
    public ListenerHandle<WatchedListListener<T>> addListener(WatchedListListener<T> listener) {
        return this.listeners.add(listener);
    }

    @Override
    public WatchedList<T> lock() {
        return new LockedWatchedList(this);
    }

    @Override
    public boolean add(int index, T value) {
        if (this.list.add(index, value)) {
            this.listeners.accept(listener -> listener.onAdded(index, value));
            return true;
        }
        return false;
    }

    @Override
    public T remove(int index) {
        Object result = this.list.remove(index);
        this.listeners.accept(listener -> listener.onRemoved(index, result));
        return result;
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T value) {
        Object oldValue = this.list.set(index, value);
        this.listeners.accept(listener -> listener.onSet(index, oldValue, value));
        return oldValue;
    }

    @Override
    public int indexOf(T value) {
        return this.list.indexOf(value);
    }

    @Override
    public int lastIndexOf(T value) {
        return this.list.lastIndexOf(value);
    }

    @Override
    public Class<T> getElementClass() {
        return this.list.getElementClass();
    }

    @Override
    public boolean add(T value) {
        if (this.list.add(value)) {
            int index = this.list.size() - 1;
            this.listeners.accept(listener -> listener.onAdded(index, value));
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(T value) {
        int index = this.list.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.list.remove(index);
        this.listeners.accept(listener -> listener.onRemoved(index, value));
        return true;
    }

    @Override
    public boolean contains(T value) {
        return this.list.contains(value);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
        this.listeners.accept(listener -> listener.onChanged());
    }

    @Override
    public Iterator<T> iterator() {
        return new SafeIterator(this.list.iterator());
    }

    private class SafeIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;

        public SafeIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }
    }
}

