/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.watched;

import javafx.beans.property.StringProperty;
import org.openzen.zengarden.delta.StringDelta;
import org.openzen.zengarden.function.Predicate;
import org.openzen.zengarden.util.ZObjects;
import org.openzen.zengarden.watched.BasicWatchedString;
import org.openzen.zengarden.watched.WatchedValue;

public interface WatchedString
extends WatchedValue<String> {
    public static WatchedString of(String value) {
        return new BasicWatchedString(value);
    }

    public String get();

    public void set(String var1);

    default public StringDelta getUpdates() {
        return StringDelta.create(this.get());
    }

    default public void apply(StringDelta updates) {
        this.set(updates.update(this.get()));
    }

    default public void bind(StringProperty property) {
        this.whenChanged(value -> {
            if (!ZObjects.equals(property.get(), value.newValue)) {
                property.set(value.newValue);
            }
        });
        property.addListener((observable, oldValue, newValue) -> {
            if (!ZObjects.equals(this.get(), newValue)) {
                this.set((String)newValue);
            }
        });
    }

    default public void bindTo(StringProperty property) {
        this.whenChanged(value -> {
            if (!ZObjects.equals(property.get(), value.newValue)) {
                property.set(value.newValue);
            }
        });
    }

    public WatchedString lock();

    public WatchedString guard(Predicate<String> var1);
}

