/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zengarden.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import org.mindrot.jbcrypt.BCrypt;
import org.openzen.zengarden.util.Charsets;
import org.openzen.zengarden.util.ZAssertionError;

public class PHPass {
    private static final char[] HEX_CHARS;
    private static final char[] ITOA64;
    private static final byte[] ATOI64;
    private int defaultWorkLevel = 10;
    private final MessageDigest md5;
    private final MessageDigest sha512;
    private final SecureRandom random;

    public static PHPass getInstance() {
        return new PHPass();
    }

    private PHPass() {
        try {
            this.random = SecureRandom.getInstanceStrong();
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha512 = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ZAssertionError("Could not initialize md5 / sha512", (Exception)ex);
        }
    }

    public String hash(String password) {
        return this.hash(password, this.defaultWorkLevel);
    }

    public String hash(String password, int workLevel) {
        byte[] randomBytes = new byte[16];
        this.random.nextBytes(randomBytes);
        return BCrypt.hashpw((String)password, (String)this.gensaltBlowfish(randomBytes, workLevel));
    }

    public boolean checkHash(String password, String hash) {
        if (hash.startsWith("U$S$")) {
            hash = hash.substring(1);
            password = this.md5Hex(password);
        }
        if (hash.startsWith("$2a$")) {
            return this.checkHashBCrypt(hash, password);
        }
        if (hash.startsWith("$H$") || hash.startsWith("$P$")) {
            return this.checkHashPHPass(hash, password);
        }
        if (hash.startsWith("$S$")) {
            return this.checkHashDrupal(hash, password);
        }
        if (hash.startsWith("_")) {
            throw new UnsupportedOperationException("Extended DES hash not supported");
        }
        return false;
    }

    private boolean checkHashBCrypt(String hash, String password) {
        return BCrypt.checkpw((String)password, (String)hash);
    }

    private boolean checkHashPHPass(String hash, String password) {
        return hash.equals(this.cryptPrivateMD5(password, hash));
    }

    private boolean checkHashDrupal(String hash, String password) {
        String calculatedHash = this.cryptPrivateSHA512(password, hash);
        System.out.println("Given hash: " + hash);
        System.out.println("Calc  hash: " + calculatedHash);
        return hash.equals(calculatedHash);
    }

    private String md5Hex(String value) {
        return this.hexString(this.md5(value));
    }

    private byte[] md5(byte[] bytes) {
        return this.md5.digest(bytes);
    }

    private byte[] md5(String value) {
        return this.md5(value.getBytes(Charsets.UTF_8));
    }

    private String hexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    private byte[] concat(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private String gensaltBlowfish(byte[] data, int workLevel) {
        int c1;
        StringBuilder result = new StringBuilder("$2a$");
        result.append(String.format(Locale.US, "%02d", workLevel));
        result.append("$");
        int i = 0;
        while (true) {
            c1 = data[i++] & 0xFF;
            result.append(ITOA64[c1 >> 2]);
            c1 = (c1 & 3) << 4;
            if (i >= 16) break;
            int c2 = data[i++] & 0xFF;
            result.append(ITOA64[(c1 |= c2 >> 4) >> 2]);
            c1 = (c2 & 0xF) << 2;
            c2 = data[i++] & 0xFF;
            result.append(ITOA64[c1 |= c2 >> 6]);
            result.append(ITOA64[c2 & 0x3F]);
        }
        result.append(ITOA64[c1]);
        return result.toString();
    }

    private String encode64(byte[] input, int count) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        do {
            int value = input[i++] & 0xFF;
            output.append(ITOA64[value & 0x3F]);
            if (i < count) {
                value |= (input[i] & 0xFF) << 8;
            }
            output.append(ITOA64[value >> 6 & 0x3F]);
            if (i++ >= count) break;
            if (i < count) {
                value |= (input[i] & 0xFF) << 16;
            }
            output.append(ITOA64[value >> 12 & 0x3F]);
            if (i++ >= count) break;
            output.append(ITOA64[value >> 18 & 0x3F]);
        } while (i < count);
        return output.toString();
    }

    private String gensaltPrivate(byte[] data, int workLevel) {
        StringBuilder output = new StringBuilder("$P$");
        output.append(ITOA64[Math.min(workLevel + 5, 30)]);
        output.append(this.encode64(data, 6));
        return output.toString();
    }

    private String gensaltExtended(byte[] data, int workLevel) {
        int count_log2 = Math.min(workLevel + 8, 24);
        int count = (1 << count_log2) - 1;
        StringBuilder output = new StringBuilder("_");
        output.append(ITOA64[count & 0x3F]);
        output.append(ITOA64[count >> 6 & 0x3F]);
        output.append(ITOA64[count >> 12 & 0x3F]);
        output.append(ITOA64[count >> 18 & 0x3F]);
        output.append(this.encode64(data, 3));
        return output.toString();
    }

    private String cryptPrivateMD5(String password, String setting) {
        String id;
        String output = "*0";
        if (setting.substring(0, 2).equals(output)) {
            output = "*1";
        }
        if (!(id = setting.substring(0, 3)).equals("$P$") && !id.equals("$H$")) {
            return output;
        }
        byte count_log2 = ATOI64[setting.charAt(3)];
        if (count_log2 < 7 || count_log2 > 30) {
            return output;
        }
        int count = 1 << count_log2;
        if (setting.length() < 12) {
            return output;
        }
        String salt = setting.substring(4, 12);
        byte[] hash = this.md5(salt + password);
        for (int i = 0; i < count; ++i) {
            hash = this.md5(this.concat(hash, password.getBytes(Charsets.UTF_8)));
        }
        return setting.substring(0, 12) + this.encode64(hash, 16);
    }

    private byte[] sha512(byte[] input) {
        return this.sha512.digest(input);
    }

    private String cryptPrivateSHA512(String password, String setting) {
        String id;
        String output = "*0";
        if (setting.substring(0, 2).equals(output)) {
            output = "*1";
        }
        if (!(id = setting.substring(0, 3)).equals("$S$")) {
            return output;
        }
        byte count_log2 = ATOI64[setting.charAt(3)];
        if (count_log2 < 7 || count_log2 > 30) {
            return output;
        }
        int count = 1 << count_log2;
        if (setting.length() < 12) {
            return output;
        }
        String salt = setting.substring(4, 12);
        byte[] hash = this.sha512((salt + password).getBytes(Charsets.UTF_8));
        for (int i = 0; i < count; ++i) {
            hash = this.sha512(this.concat(hash, password.getBytes(Charsets.UTF_8)));
        }
        return setting.substring(0, 12) + this.encode64(hash, 64).substring(0, 43);
    }

    static {
        int i;
        HEX_CHARS = "0123456789ABCDEF".toCharArray();
        ITOA64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        ATOI64 = new byte[128];
        for (i = 0; i < ATOI64.length; ++i) {
            PHPass.ATOI64[i] = -1;
        }
        for (i = 0; i < ITOA64.length; ++i) {
            PHPass.ATOI64[PHPass.ITOA64[i]] = (byte)i;
        }
    }
}

